// <><><><><><> START CHANNEL FOLLOW MODEL <><><><><><>

document.addEventListener('DOMContentLoaded', function () {
  const modal = document.getElementById('channels-follow-model');
  const doneButton = document.getElementById('done-button');

  if (modal && doneButton) {
    doneButton.addEventListener('click', function (event) {
      event.preventDefault();
      modal.style.display = 'none';
    });
  }
});

// <><><><><><> END CHANNEL FOLLOW MODEL <><><><><><>
// <><><><><><> Membership Plan js <><><><><><>

document.addEventListener('DOMContentLoaded', function () {
  // Initialize all tenure selectors on page load
  initializeTenureSelectors();

  // Use event delegation to handle changes on dynamically added .tenure-selector elements
  document.addEventListener('change', function (event) {
    if (event.target.classList.contains('tenure-selector')) {
      updateDisplayedValues(event.target);
    }
  });

  // Function to initialize tenure selectors
  function initializeTenureSelectors() {
    const tenureSelectors = document.querySelectorAll('.tenure-selector');
    tenureSelectors.forEach(selector => {
      // Set initial values
      updateDisplayedValues(selector);
    });
  }

  // Function to update displayed values
  function updateDisplayedValues(selector) {
    let price, duration, tenureId;

    if (selector.tagName === 'SELECT') {
      const selectedOption = selector.options[selector.selectedIndex];
      price = selectedOption.getAttribute('data-price');
      duration = selectedOption.getAttribute('data-duration');
      tenureId = selector.value;
    } else {
      // For non-select elements like div
      price = selector.getAttribute('data-price');
      duration = selector.getAttribute('data-duration');
      tenureId = selector.getAttribute('data-tenure-id');
    }

    const planId = selector.getAttribute('data-plan-id');
    const planName = selector.getAttribute('data-plan-name');

    // Find the card that contains this selector
    const card = selector.closest('.card');

    // Get currency from the first .fs-10 element in the card
    const currencyElement = card.querySelector('.fs-10');
    const currency = currencyElement ? currencyElement.textContent : '$'; // Fallback to '$' if not found

    // Update the displayed price and duration
    const priceElement = card.querySelector('.fw-bold[style="font-size: 45px"]');
    const durationElement = card.querySelector('.fs-6.text-muted');

    if (priceElement) {
      // Clear and update the price element
      priceElement.innerHTML = `<span class="fs-10">${currency}</span>${Number(price).toLocaleString()}`;
    }

    if (durationElement) {
      // Update the duration element
      const monthText = parseInt(duration) > 1 ? 's' : '';
      durationElement.textContent = `/${duration} month${monthText}`;
    }

    // Update the form values (if the form exists)
    const form = card.querySelector('.plan-form');
    if (form) {
      const tenureInput = form.querySelector('.tenure-id-input');
      const amountInput = form.querySelector('.amount-input');
      if (tenureInput) tenureInput.value = tenureId;
      if (amountInput) amountInput.value = price;
    }
  }
});

// <><><><><><> END MEMBERSHIP PLAN JS <><><><><><>

document.addEventListener('DOMContentLoaded', function () {
  const profileImagePreview = document.getElementById('profile-image-preview');
  const profileImageInput = document.getElementById('change-profile');
  if (profileImageInput) {

    profileImageInput.addEventListener('change', function (event) {
      const file = event.target.files[0];
      if (file) {
        const reader = new FileReader();
        reader.onload = function (e) {
          profileImagePreview.src = e.target.result;
        };
        reader.readAsDataURL(file);
      }
    });
  }
});

const profileImage = document.getElementById('profileImage');
if (profileImage) {
  profileImage.addEventListener('click', function () {
    document.getElementById('dropdownMenu').classList.toggle('show');
  });
}
const logoutLink = document.getElementById('logout-link');
if (logoutLink) {
  logoutLink.addEventListener('click', function (event) {
    event.preventDefault(); // Prevent the default anchor click behavior
    document.getElementById('logout-form').submit(); // Submit the logout form
  });
}


window.onclick = function (event) {
  if (!event.target.matches('#profileImage')) {
    var dropdowns = document.getElementsByClassName("dropdown-content");
    for (var i = 0; i < dropdowns.length; i++) {
      var openDropdown = dropdowns[i];
      if (openDropdown.classList.contains('show')) {
        openDropdown.classList.remove('show');
      }
    }
  }
}


/* Open Register model */
document.addEventListener('DOMContentLoaded', () => {
  const openSignupModalMobile = document.querySelector('.open-signup-modal-mobile');
  const openSignupModal = document.querySelector('.open-signup-modal');
  const ucAccountModal = document.getElementById('uc-account-modal');

  // Check if the elements exist before adding event listeners
  if (openSignupModalMobile && ucAccountModal) {
    openSignupModalMobile.addEventListener('click', () => {
      ucAccountModal.querySelector('li:nth-child(2) a').click();
    });
  }

  if (openSignupModal && ucAccountModal) {
    openSignupModal.addEventListener('click', () => {
      ucAccountModal.querySelector('li:nth-child(2) a').click();
    });
  }
});

//  <><><><><><><> ADD JS FOR TRANSLATE POST DETAILS PAGE <><><><><><><>
document.addEventListener('DOMContentLoaded', () => {
  // Select the language dropdown
  const languageSelect = document.querySelector('select[name="language"]');
  if (!languageSelect) {
    return;
  }

  // Select the text container
  const textContainer = document.querySelector('#translateMe');
  if (!textContainer) {
    return;
  }

  // List of supported language codes
  const availableLanguages = [
    'af', 'sq', 'am', 'ar', 'hy', 'az', 'eu', 'be', 'bn', 'bs', 'bg', 'ca', 'ceb', 'ny',
    'zh-cn', 'zh-tw', 'co', 'hr', 'cs', 'da', 'nl', 'en', 'eo', 'et', 'tl', 'fi', 'fr',
    'fy', 'gl', 'ka', 'de', 'el', 'gu', 'ht', 'ha', 'haw', 'iw', 'hi', 'hmn', 'hu', 'is',
    'ig', 'id', 'ga', 'it', 'ja', 'jw', 'kn', 'kk', 'km', 'rw', 'ko', 'ku', 'ky', 'lo',
    'la', 'lv', 'lt', 'lb', 'mk', 'mg', 'ms', 'ml', 'mt', 'mi', 'mr', 'mn', 'my', 'ne',
    'no', 'or', 'ps', 'fa', 'pl', 'pt', 'pa', 'ro', 'ru', 'sm', 'gd', 'sr', 'st', 'sn',
    'sd', 'si', 'sk', 'sl', 'so', 'es', 'su', 'sw', 'sv', 'tg', 'ta', 'tt', 'te', 'th',
    'tr', 'tk', 'uk', 'ur', 'ug', 'uz', 'vi', 'cy', 'xh', 'yi', 'yo', 'zu'
  ];

  // Function to split text into chunks
  const splitText = (text, maxLength) => {
    const chunks = [];
    for (let i = 0; i < text.length; i += maxLength) {
      chunks.push(text.slice(i, i + maxLength));
    }
    return chunks;
  };

  // Function to translate text with retry logic
  async function translateText(text, targetLang, retries = 3) {
    const maxLength = 2000; // Max length per request to avoid 400 errors
    const chunks = splitText(text, maxLength);
    const translations = [];
    const delay = ms => new Promise(resolve => setTimeout(resolve, ms));

    for (const chunk of chunks) {
      for (let i = 0; i < retries; i++) {
        try {
          const response = await fetch(
            `https://translate.googleapis.com/translate_a/single?client=gtx&sl=auto&tl=${targetLang}&dt=t&q=${encodeURIComponent(chunk)}`
          );
          if (!response.ok) {
            const errorText = await response.text();
            throw new Error(`HTTP ${response.status}: ${errorText}`);
          }
          const data = await response.json();
          if (!data || !data[0]) throw new Error('Invalid API response');
          translations.push(data[0].map(item => item[0]).join(''));
          break; // Success, move to next chunk
        } catch (error) {
          if (i < retries - 1) {
            console.warn(`Retry ${i + 1} for chunk: ${error.message}`);
            await delay(1000 * (i + 1)); // Exponential backoff
          } else {
            throw error; // All retries failed
          }
        }
      }
    }
    return translations.join('');
  }

  // Add change event listener to the language dropdown
  languageSelect.addEventListener('change', async function () {
    const targetLang = availableLanguages.includes(this.value) ? this.value : 'gu';
    const originalText = textContainer.innerText.trim();
    if (!originalText) {

      // Use SweetAlert for a more user-friendly error message
      if (typeof Swal !== 'undefined') {
        Swal.fire({
          icon: 'warning',
          title: 'No Text Found',
          text: 'There is no text available to translate.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#3085d6'
        });
      }

      textContainer.innerHTML = 'No text available';
      return;
    }

    try {
      // Log text length for debugging
      console.log('Original text length:', originalText.length);
      console.log('Encoded text length:', encodeURIComponent(originalText).length);

      // Translate the text
      const translatedText = await translateText(originalText, targetLang);
      textContainer.innerHTML = translatedText;
    } catch (error) {

      // Use SweetAlert for translation error
      if (typeof Swal !== 'undefined') {
        Swal.fire({
          icon: 'error',
          title: 'Translation Failed',
          text: 'Unable to translate the text. Please try again later.',
          confirmButtonText: 'OK',
          confirmButtonColor: '#3085d6'
        });
      }

      textContainer.innerHTML = 'Translation failed. Please try again later.';
    }
  });
});
// <><><><><><> END TRANSLATE POST DETAILS PAGE <><><><><><>

//  <><><><><><><> ADD JS FOR LOCAL LIMITS COUNT <><><><><><><>
function logIfPostRoute() {
  const path = window.location.pathname;

  if (path.startsWith('/webstories') || path.startsWith('/webstories')) {
    console.log('🚀 You are on a posts/* story!');
    updateVisitCount('webstoriesVisits', storyVisitLimit, '/membership');
  }
}
const redirectUrl = "{{ route('membership.index') }}";

// Utility to update visit count and redirect if over limit
function updateVisitCount(key, limit, redirectUrl) {
  let count = parseInt(localStorage.getItem(key)) || 0;
  count += 1;
  localStorage.setItem(key, count);
  console.log(`📊 ${key} count: ${count}`);

  if (limit !== undefined && count > limit) {
    console.log(`⚠️ Visit limit exceeded for ${key}. Redirecting to ${redirectUrl}`);
    window.location.href = redirectUrl;
  }
}

// Check on page load
document.addEventListener('DOMContentLoaded', logIfPostRoute);


// Check on browser navigation (back/forward)
window.addEventListener('popstate', logIfPostRoute);


// <><><><><><><> ADD JS FOR DAILY LIMIT MODEL <><><><><><><> 
document.addEventListener('DOMContentLoaded', function () {
  const dailyLimitModal = new bootstrap.Modal(document.getElementById('dailyLimitModal'));
  const wrapper = document.getElementById('wrapper');

  // Show the modal and blur the background
  dailyLimitModal.show();
  wrapper.classList.add('blur-background');

  // Remove blur when the modal is hidden
  document.getElementById('dailyLimitModal').addEventListener('hidden.bs.modal', function () {
    wrapper.classList.remove('blur-background');
  });

  // Handle "Read more" link click
  const readMoreLink = document.getElementById('readMoreLink');
  readMoreLink.addEventListener('click', function (event) {
    event.preventDefault(); // Prevent default link behavior
    wrapper.classList.add('blur-background');
    dailyLimitModal.show();
  });
});

// <><><><><><><> ADD JS FOR POST DAILY AND SUBSCRIPTION LIMIT <><><><><><><>
document.addEventListener('DOMContentLoaded', function () {
  const readMoreLink = document.getElementById('readMoreLink');
  const wrapper = document.getElementById('wrapper');

  const dailyLimitModalEl = document.getElementById('dailyLimitModal');
  const subscriptionLimitModalEl = document.getElementById('subscriptionLimitFreeTrialModal');

  const dailyLimitModal = new bootstrap.Modal(dailyLimitModalEl);
  const subscriptionLimitModal = new bootstrap.Modal(subscriptionLimitModalEl);

  if (readMoreLink) {
    readMoreLink.addEventListener('click', function (event) {
      const isDailyLimit = readMoreLink.dataset.dailyLimit === '1';
      const isSubscriptionLimit = readMoreLink.dataset.subscriptionLimit === '1';

      if (isDailyLimit || isSubscriptionLimit) {
        event.preventDefault(); // Prevent opening the link

        wrapper.classList.add('blur-background');

        if (isSubscriptionLimit) {
          subscriptionLimitModal.show();
          subscriptionLimitModalEl.addEventListener('hidden.bs.modal', () => {
            wrapper.classList.remove('blur-background');
          });
        } else if (isDailyLimit) {
          dailyLimitModal.show();
          dailyLimitModalEl.addEventListener('hidden.bs.modal', () => {
            wrapper.classList.remove('blur-background');
          });
        }
      }
    });
  }
});

document.addEventListener('DOMContentLoaded', function () {
  // Check if the subscription limit and free trial modal exists
  const subscriptionLimitFreeTrialModalElement = document.getElementById(
    'subscriptionLimitFreeTrialModal');
  if (subscriptionLimitFreeTrialModalElement) {
    const subscriptionLimitFreeTrialModal = new bootstrap.Modal(subscriptionLimitFreeTrialModalElement);
    const wrapper = document.getElementById('wrapper');

    // Show the modal and blur the background
    subscriptionLimitFreeTrialModal.show();
    wrapper.classList.add('blur-background');

    // Remove blur when the modal is hidden
    subscriptionLimitFreeTrialModalElement.addEventListener('hidden.bs.modal', function () {
      wrapper.classList.remove('blur-background');
    });
  }
});

// <><><><><><><> END JS FOR POST DAILY AND SUBSCRIPTION LIMIT <><><><><><><>

// <><><><><><><> ADD JS FOR EPAPER AND MAGAZINE DAILY AND SUBSCRIPTION LIMIT <><><><><><><>

document.addEventListener('DOMContentLoaded', function () {
  const wrapper = document.getElementById('wrapper');
  const dailyLimitModalEl = document.getElementById('dailyLimitModal');
  const subscriptionLimitModalEl = document.getElementById('subscriptionLimitModal');

  // Initialize modals
  const dailyLimitModal = dailyLimitModalEl ? new bootstrap.Modal(dailyLimitModalEl) : null;
  const subscriptionLimitModal = subscriptionLimitModalEl ? new bootstrap.Modal(
    subscriptionLimitModalEl) : null;

  // Show modal based on session variable
  const showModal = window.showModal;
  if (showModal === 'daily' && dailyLimitModal) {
    dailyLimitModal.show();
    wrapper.classList.add('blur-background');
  } else if (showModal === 'subscription' && subscriptionLimitModal) {
    subscriptionLimitModal.show();
    wrapper.classList.add('blur-background');
  }

  // Remove blur when modals are hidden
  if (dailyLimitModalEl) {
    dailyLimitModalEl.addEventListener('hidden.bs.modal', function () {
      wrapper.classList.remove('blur-background');
    });
  }
  if (subscriptionLimitModalEl) {
    subscriptionLimitModalEl.addEventListener('hidden.bs.modal', function () {
      wrapper.classList.remove('blur-background');
    });
  }

  // Handle "Read more" link clicks
  const readMoreLinks = document.querySelectorAll('.read-more-link');
  readMoreLinks.forEach(link => {
    link.addEventListener('click', function (event) {
      const isDailyLimit = link.dataset.dailyLimit === '1';
      const isSubscriptionLimit = link.dataset.subscriptionLimit === '1';

      if (isDailyLimit || isSubscriptionLimit) {
        event.preventDefault(); // Prevent default link behavior
        wrapper.classList.add('blur-background');

        if (isSubscriptionLimit && subscriptionLimitModal) {
          subscriptionLimitModal.show();
        } else if (isDailyLimit && dailyLimitModal) {
          dailyLimitModal.show();
        }
      }
    });
  });
});
// <><><><><><><> END JS FOR POST DAILY AND SUBSCRIPTION LIMIT <><><><><><><>

// // <><><><><><><> ADD JS FOR  VIDEOS FILTER  <><><><><><><>

document.addEventListener('DOMContentLoaded', function () {
  const sortSelect = document.getElementById('sort_by');
  const videosUrl = sortSelect.getAttribute('data-videos-url');
  const videosContainer = document.getElementById('videos-container');
  const paginationContainer = document.getElementById('pagination-container');
  const videoCountSpan = document.getElementById('video-count');

  // Set selected filters from URL if present
  const urlParams = new URLSearchParams(window.location.search);
  const currentSort = urlParams.get('sort');

  if (currentSort) sortSelect.value = currentSort;

  function fetchVideos(sortValue, typeValue) {
    const url = new URL(videosUrl, window.location.origin);
    url.searchParams.set('sort', sortValue);

    videosContainer.innerHTML = '<div class="text-center py-5 w-100">Loading videos...</div>';

    fetch(url)
      .then(response => response.text())
      .then(html => {
        const parser = new DOMParser();
        const doc = parser.parseFromString(html, 'text/html');

        const newVideos = doc.getElementById('videos-container');
        const newPagination = doc.getElementById('pagination-container');
        const newVideoCount = doc.getElementById('video-count');

        if (newVideos && videosContainer) {
          videosContainer.innerHTML = newVideos.innerHTML;
        }

        if (newPagination && paginationContainer) {
          paginationContainer.innerHTML = newPagination.innerHTML;
        }

        if (newVideoCount && videoCountSpan) {
          videoCountSpan.innerHTML = newVideoCount.innerHTML;
        }

        // Update browser URL
        window.history.replaceState(null, '', url);
      })
      .catch({
      });
  }
  // ✅ Add this to respond to dropdown changes
  sortSelect.addEventListener('change', function () {
    fetchVideos(sortSelect.value);
  });

  // ✅ Optional: Load videos on page load if `sort` is set
  if (currentSort) {
    fetchVideos(currentSort);
  }
});

// <><><><><><><> FILTER + SORT JS FOR VIDEOS PAGE <><><><><><><>

// <><><><><><><><><> ADD JS FOR E-NEWS PAPER PAGE <><><><><><><><><>
document.addEventListener('DOMContentLoaded', function () {
  const datePicker = document.getElementById('date-picker');
  const noDataPanel = document.getElementById('no-data-panel');

  // Set max date to today
  const today = new Date().toISOString().split('T')[0];
  datePicker.max = today;

  // Date picker change handler
  datePicker.addEventListener('change', function () {
    filterNewspapers();
  });

  // Filter newspapers function
  function filterNewspapers() {
    const selectedDate = datePicker.value;
    const newspaperItems = document.querySelectorAll('.newspaper-item');

    // Hide all items initially
    newspaperItems.forEach(item => {
      item.style.display = 'none';
    });

    // Filter items based on selected date
    let visibleCount = 0;
    setTimeout(() => {
      newspaperItems.forEach(item => {
        const itemDate = item.getAttribute('data-date');
        let showItem = true;

        // Date filter
        if (selectedDate && itemDate !== selectedDate) {
          showItem = false;
        }

        if (showItem) {
          item.style.display = 'block';
          visibleCount++;
        }
      });

      // Update count
      updateCount(visibleCount);

      // Show or hide the "No Subscription found" panel
      if (visibleCount === 0) {
        noDataPanel.style.display = 'block';
      } else {
        noDataPanel.style.display = 'none';
      }
    }, 300); // Small delay to show loading effect
  }

  // Update count function
  function updateCount(visibleCount) {
    const totalCount = document.querySelectorAll('.newspaper-item').length;
    document.getElementById('newspaper-count').textContent = `Showing ${visibleCount} newspapers out of ${totalCount} total.`;
  }

  // Initialize count and panel visibility on page load
  const initialCount = document.querySelectorAll('.newspaper-item').length;
  updateCount(initialCount);
  if (initialCount === 0) {
    noDataPanel.style.display = 'block';
  } else {
    noDataPanel.style.display = 'none';
  }
});
// <><><><><><><><><> END JS FOR E-NEWS PAPER PAGE <><><><><><><><><>

// <><><><><><><><><> START JS FOR E-NEWS MAGAZINE PAGE <><><><><><><><><>
document.addEventListener('DOMContentLoaded', function () {
  const datePicker = document.getElementById('date-picker');
  const noDataPanel = document.getElementById('no-data-panel');

  // Set max date to today
  const today = new Date().toISOString().split('T')[0];
  datePicker.max = today;

  // Date picker change handler
  datePicker.addEventListener('change', function () {
    filterNewspapers();
  });

  // Filter newspapers function
  function filterNewspapers() {
    const selectedDate = datePicker.value;
    const newspaperItems = document.querySelectorAll('.newspaper-item');

    // Add hiding class to all items
    newspaperItems.forEach(item => {
      item.classList.add('hiding');
    });

    // Filter items based on selected date
    let visibleCount = 0;
    setTimeout(() => {
      newspaperItems.forEach(item => {
        const itemDate = item.getAttribute('data-date');
        let showItem = true;

        // Date filter
        if (selectedDate && itemDate !== selectedDate) {
          showItem = false;
        }

        if (showItem) {
          item.style.display = 'block';
          item.classList.remove('hiding');
          visibleCount++;
        } else {
          item.style.display = 'none';
          item.classList.remove('hiding');
        }
      });

      // Show or hide no-data panel
      if (visibleCount === 0) {
        noDataPanel.style.display = 'block';
      } else {
        noDataPanel.style.display = 'none';
      }

      // Update count
      updateCount(visibleCount);
    }, 400); // Small delay to show loading effect
  }

  // Update count function
  function updateCount(visibleCount) {
    const totalCount = document.querySelectorAll('.newspaper-item').length;
    document.getElementById('newspaper-count').textContent =
      `Showing ${visibleCount} newspapers out of ${totalCount} total.`;
  }

  // Initialize count and no-data panel on page load
  const initialCount = document.querySelectorAll('.newspaper-item').length;
  updateCount(initialCount);
  noDataPanel.style.display = initialCount === 0 ? 'block' : 'none';

  // Reset filter when date is cleared
  datePicker.addEventListener('input', function () {
    if (!this.value) {
      // Show all newspapers when date is cleared
      const newspaperItems = document.querySelectorAll('.newspaper-item');
      newspaperItems.forEach(item => {
        item.style.display = 'block';
        item.classList.remove('hiding');
      });
      noDataPanel.style.display = 'none';
      updateCount(newspaperItems.length);
    }
  });
});
// <><><><><><><><><> END JS FOR E-NEWS MAGAZINE PAGE <><><><><><><><><>


// <><><><><><><> START JS FOR GOOGLE LOGIN <><><><><><><>
class FirebaseAuth {
  constructor() {
    this.app = null;
    this.auth = null;
    this.provider = null;
    this.isInitialized = false;
    this.config = null;
  }

  // Get Firebase config from hidden div with base64 encoded data
  getConfigFromHiddenDiv() {
    try {
      const hiddenDiv = document.getElementById('firebase-config');
      if (!hiddenDiv) {
        throw new Error('Firebase config element not found');
      }

      const encodedConfig = hiddenDiv.dataset.config;
      if (!encodedConfig) {
        throw new Error('Firebase config data not found in element');
      }

      const decodedConfig = JSON.parse(atob(encodedConfig));

      // Validate required fields
      if (!decodedConfig || !decodedConfig.apiKey || !decodedConfig.projectId) {
        throw new Error('Invalid Firebase configuration - missing required fields');
      }

      console.log('Firebase config loaded successfully from hidden div');
      return decodedConfig;

    } catch (error) {
      return null;
    }
  }

  async init() {
    try {
      // Get config from hidden div
      this.config = this.getConfigFromHiddenDiv();
      if (!this.config) {
        return false;
      }

      console.log('Initializing Firebase with config:', { ...this.config, apiKey: '[HIDDEN]' });

      // Import Firebase modules dynamically
      const { initializeApp } = await import('https://www.gstatic.com/firebasejs/10.7.1/firebase-app.js');
      const { getAuth, GoogleAuthProvider } = await import('https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js');

      // Initialize Firebase
      this.app = initializeApp(this.config);
      this.auth = getAuth(this.app);
      this.provider = new GoogleAuthProvider();

      // Configure Google Auth Provider
      this.provider.addScope('profile');
      this.provider.addScope('email');
      this.provider.setCustomParameters({
        'prompt': 'select_account'
      });

      this.isInitialized = true;
      console.log('Firebase initialized successfully');
      return true;

    } catch (error) {
      return false;
    }
  }

  async signInWithGoogle() {
    if (!this.isInitialized) {
      return null;
    }

    try {
      const { signInWithPopup } = await import('https://www.gstatic.com/firebasejs/10.7.1/firebase-auth.js');
      const result = await signInWithPopup(this.auth, this.provider);
      const user = result.user;

      return {
        uid: user.uid,
        email: user.email,
        name: user.displayName,
        photo: user.photoURL,
        token: await user.getIdToken()
      };

    } catch (error) {
      throw error;
    }
  }

  async sendToBackend(userData, endpoint = '/google-auth') {
    try {
      const response = await fetch(endpoint, {
        method: 'POST',
        headers: {
          'Content-Type': 'application/json',
          'X-CSRF-TOKEN': document.querySelector('meta[name="csrf-token"]')?.getAttribute('content') || '',
          'Accept': 'application/json',
          'X-Requested-With': 'XMLHttpRequest'
        },
        body: JSON.stringify(userData),
        credentials: 'same-origin'
      });

      if (!response.ok) {
        const errorData = await response.json().catch(() => ({}));
        throw new Error(errorData.message || `HTTP error! status: ${response.status}`);
      }

      return await response.json();

    } catch (error) {
      throw error;
    }
  }

  // Update button state
  updateButtonState(loading = false, text = null) {
    const btn = document.getElementById('google-login-btn');
    if (!btn) return;

    if (loading) {
      btn.innerHTML = '<i class="fas fa-spinner fa-spin"></i> Signing in...';
      btn.disabled = true;
      btn.style.opacity = '0.7';
    } else {
      btn.innerHTML = text || '<i class="icon icon-1 unicon-logo-google"></i><span>Sign in with Google</span>';
      btn.disabled = false;
      btn.style.opacity = '1';
    }
  }

  // Show error message
  showError(message) {
    const errorContainer = document.getElementById('google-login-error');
    if (errorContainer) {
      errorContainer.textContent = message;
      errorContainer.style.display = 'block';

      // Auto-hide error after 5 seconds
      setTimeout(() => {
        errorContainer.style.display = 'none';
      }, 5000);
    }
  }

  // Get user-friendly error message
  getUserFriendlyErrorMessage(error) {
    const errorMessages = {
      'auth/popup-closed-by-user': 'Sign-in was cancelled.',
      'auth/popup-blocked': 'Pop-up was blocked by your browser. Please allow pop-ups and try again.',
      'auth/cancelled-popup-request': 'Sign-in was cancelled.',
      'auth/network-request-failed': 'Network error. Please check your connection and try again.',
      'auth/too-many-requests': 'Too many failed attempts. Please try again later.',
      'auth/user-disabled': 'This account has been disabled.',
      'auth/operation-not-allowed': 'Google sign-in is not enabled.',
      'auth/invalid-api-key': 'Invalid API key configuration.',
      'auth/app-deleted': 'Firebase app configuration error.',
    };

    return errorMessages[error.code] || error.message || 'Authentication failed. Please try again.';
  }

  async handleGoogleAuth(endpoint = '/google-auth') {
    const btn = document.getElementById('google-login-btn');


    // Clear any previous errors
    const errorContainer = document.getElementById('google-login-error');
    if (errorContainer) {
      errorContainer.style.display = 'none';
    }

    this.updateButtonState(true);

    try {
      // Initialize Firebase if not already done
      if (!this.isInitialized) {
        const initialized = await this.init();
        if (!initialized) {
          throw new Error('Failed to initialize Firebase');
        }
      }

      // Sign in with Google
      const userData = await this.signInWithGoogle();
      if (!userData) {
        throw new Error('Failed to get user data from Google');
      }

      console.log('User signed in:', userData.email);

      // Send to backend
      const response = await this.sendToBackend(userData, endpoint);

      if (response.error === false || response.success === true) {
        this.updateButtonState(false, '<i class="fas fa-check"></i> Success! Redirecting...');

        setTimeout(() => {
          window.location.href = response.redirect || '/';
        }, 1000);
      } else {
        throw new Error(response.message || 'Authentication failed on server');
      }

    } catch (error) {

      const errorMessage = this.getUserFriendlyErrorMessage(error);
      this.showError(errorMessage);
      this.updateButtonState(false);
    }
  }
}

// Initialize Firebase Auth when DOM is ready
document.addEventListener('DOMContentLoaded', function () {
  const firebaseAuth = new FirebaseAuth();

  // Set up click handler for Google login button
  const btn = document.getElementById('google-login-btn');
  if (btn) {
    btn.addEventListener('click', function (e) {
      e.preventDefault();
      firebaseAuth.handleGoogleAuth();
    });
  }
});

// <><><><><><><> END JS OF GOOGLE LOGIN <><><><><><><>

// Centralized click tracking function
function trackAdClick(rawId) {
  const adId = parseInt(String(rawId).replace(/[^\d]/g, ''), 10);
  if (!adId) return;

  const csrfToken = document.querySelector('meta[name="csrf-token"]')?.content;


  fetch("/ads/click", {
    method: "POST",
    headers: {
      "Content-Type": "application/x-www-form-urlencoded",
      "X-CSRF-TOKEN": csrfToken
    },
    body: `ad_id=${adId}`
  }).catch(err => console.error("Click tracking failed:", err));
}

// jQuery-based centralized click tracking
$(document).ready(function () {
  $.ajaxSetup({
    headers: {
      "X-CSRF-TOKEN": $('meta[name="csrf-token"]').attr("content")
    }
  });

  $(document).on("click", "a[data-ad-id]", function (e) {
    const rawId = $(this).data("ad-id");
    const adId = parseInt(String(rawId).replace(/[^\d]/g, ''), 10);

    if (!adId) return;

    $.ajax({
      url: "/ads/click",
      method: "POST",
      data: { ad_id: adId },
      error: function (err) {
        console.error("Click tracking failed:", err);
      }
    });
  });
});

// <><><><><><><> START JS FOR POST DETAIL PAGE ADS <><><><><><><>
$(function () {
  function fetchAd(key, cb) {
    $.getJSON(`/ads/${key}`)
      .done(function (ad) {
        cb(ad);
      })
      .fail(function () {
        cb(null);
      });
  }

  function adCard(ad) {
    if (!ad || !ad.horizontal_image || !ad.id) return '';

    return `
        <div class="post-author panel py-4 px-3 sm:p-3 xl:p-4 bg-gray-25 dark:bg-opacity-10 rounded lg:rounded-2">
        <div class="row g-4 items-center">
                  <div class="col-12 sm:col-5 xl:col-3 position-relative">
                    <p class="badge bg-white text-primary fw-bold  position-absolute top-0 start-0 mt-1  ms-3 fw-semibold" style="z-index: 10;">
            Sponsored Advertisement </p>
              <!-- Ad Image -->
              <figure class="featured-image m-0 ratio ratio-4x3 rounded uc-transition-toggle overflow-hidden bg-gray-25 dark:bg-gray-800">
                  <a href="${ad.imageUrl || '#'}" target="_blank" class="ad-click-link"  data-ad-id="${ad.id}"
                    data-caption="${ad.title || 'Sponsored'}">
                      <img class="media-cover image uc-transition-scale-up uc-transition-opaque"
                          src="${ad.vertical_image}" 
                          alt="${ad.image_alt || ad.title || 'Sponsored Ad'}"
                          data-uc-img="loading: lazy"
                          style="object-fit: cover;">
                  </a>
              </figure>
          </div>

          <div class="col">
              <div class="panel vstack items-start gap-2 md:gap-3 text-start">
                  <h4 class="h5 lg:h4 m-0 text-truncate-2 text-start">${ad.title || ''}</h4>
                  <p class="fs-6 lg:fs-5 text-truncate-2 text-start">${ad.description || ''}</p>
              </div>
          </div>
      </div>
  </div>

    `;
  }

  function rotatePostDetailAd(container, key, interval = 13000) {
    let holder = $(container);
    if (!holder.length) return;

    function loadAd() {
      fetchAd(key, ad => {
        const adHtml = adCard(ad);
        if (adHtml) {
          holder.html(adHtml);
        } else {
          holder.empty();
        }
      });
    }

    loadAd();
    setInterval(loadAd, interval);
  }

  // Post detail placement
  rotatePostDetailAd("#post-detail-ad", "post_detail", 13000);

  // Centralized click tracking
  $(document).on("click", "a[data-ad-id]", function () {
    let adId = $(this).data("ad-id");
    if (adId) {
      trackAdClick(adId);
    }
  });
});
// <><><><><><><> END JS OF POST DETAIL PAGE ADS <><><><><><><>

// <><><><><><><> START JS FOR BANNER POSTS ADS <><><><><><><>
document.addEventListener("DOMContentLoaded", function () {
  function loadAd() {
    let adImage = document.getElementById("rotatingAdBanner");
    let adMobile = document.getElementById("rotatingAdBannerMobile");
    let adLink = document.getElementById("bannerAdLink");
    let adOverlay = document.getElementById("bannerAdOverlay");
    let postHeader = document.querySelector(".post-header");

    if (!adImage || !adLink || !adOverlay) return;

    let apiUrl = adImage.dataset.url;
    if (!apiUrl) return;

    fetch(apiUrl)
      .then(res => res.ok ? res.json() : Promise.reject('Network error'))
      .then(ad => {
        if (ad && ad.horizontal_image && ad.id) {
          adImage.src = ad.horizontal_image;
          adImage.alt = ad.image_alt || ad.title || 'Sponsored Ad';

          if (adMobile) {
            adMobile.src = ad.horizontal_image;
            adMobile.alt = ad.image_alt || ad.title || 'Sponsored Ad';
          }

          adLink.href = ad.imageUrl || "#";
          adOverlay.href = ad.imageUrl || "#";
          adLink.dataset.adId = ad.id;
          adOverlay.dataset.adId = ad.id;

          const adTitle = document.getElementById("adTitle");
          const adClicks = document.getElementById("adClicks");

          if (adTitle) adTitle.textContent = ad.title || "";
          if (adClicks) adClicks.textContent = ad.clicks || 0;

          if (postHeader) postHeader.style.display = "block";
        } else {
          // Hide the banner if no valid ad
          if (postHeader) postHeader.style.display = "none";
        }
      })
      .catch(err => {
        if (postHeader) postHeader.style.display = "none";
      });
  }

  // Centralized click tracking
  document.addEventListener("click", function (e) {
    let target = e.target.closest("a[data-ad-id]");
    if (!target) return;
    trackAdClick(target.dataset.adId);
  });

  // Load ad once on page load (no interval)
  loadAd();
});
// <><><><><><><> END JS OF BANNER POSTS ADS <><><><><><><>

// <><><><><><><> START JS FOR LATEST AND POPULAR POSTS ADS <><><><><><><>
$(document).ready(function () {
  function fetchAd(placementKey, userId = null, callback) {
    $.ajax({
      url: userId ? `/ads/${placementKey}?userId=${userId}` : `/ads/${placementKey}`,
      type: 'GET',
      dataType: 'json',
      success: function (data) {
        callback(data);
      },
      error: function () {
        callback(null); // Silent fail
      }
    });
  }

  function createLatestAdHtml(ad) {
    if (!ad || !ad.vertical_image || !ad.id) return '';

    const adTitle = ad.title || 'Advertisement';
    const adUrl = ad.imageUrl || '#';
    const adImage = ad.vertical_image;
    const adImageAlt = ad.image_alt || 'Advertisement';
    const adDescription = ad.description || 'Advertisement Content';
    return `
            <div class="widget-content">
                <article class="post type-post panel uc-transition-toggle">
                    <div class="row child-cols g-2 lg:g-3" data-uc-grid>
                        <div class="col-auto">
                            <div class="post-media panel overflow-hidden max-w-150px min-w-100px lg:min-w-250px">
                                <div class="featured-image bg-gray-25 dark:bg-gray-800 ratio ratio-3x2">
                                    <a href="${adUrl}" target="_blank" class="position-cover" data-ad-id="${ad.id}">
                                        <img class="media-cover image uc-transition-scale-up uc-transition-opaque"
                                             src="${adImage}" 
                                             alt="${adImageAlt}" 
                                             data-uc-img="loading: lazy">
                                    </a>
                                </div>
                            </div>
                        </div>
                        <div>
                            <div class="post-header panel vstack justify-between gap-1">
                                <h3 class="post-title h5 lg:h4 m-0 text-truncate-2 hover:text-primary">
                                    <a class="text-none duration-150" href="${adUrl}" title="${adTitle}" data-ad-id="${ad.id}">${adTitle}</a>
                                </h3>
                            </div>
                            <p class="post-excrept ft-tertiary fs-6 text-gray-900 dark:text-white text-opacity-60 text-truncate-2 my-1">
                                ${adDescription}
                            </p>
                            <div class="d-flex justify-between">
                                <div>
                                    <a  class="post-comments text-none hstack gap-narrow badge bg-primary text-white" title="Sponsored">
                                        Sponsor Ads
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </article>
            </div>
        `;
  }

  function insertStaticAd(sectionSelector, placementKey, position = 'latestRandom', userId = null) {
    const $section = $(sectionSelector);
    if (!$section.length) return;

    const posts = $section.children('div');
    if (posts.length === 0) return;

    const $adContainer = $('<div class="ad-placeholder full-width-ad"></div>');

    if (position === 'latestRandom') {
      // Ensure we don't exceed the number of posts
      const maxIndex = Math.min(6, posts.length - 1);
      const randomIndex = Math.floor(Math.random() * (maxIndex + 1)); // 0 to maxIndex
      $(posts[randomIndex]).after($adContainer);
    } else if (position === 'last') {
      $(posts[posts.length - 1]).after($adContainer); // Popular post: after last
    }

    fetchAd(placementKey, userId, function (ad) {
      if (!ad) {
        $adContainer.hide();
        return;
      }

      const adHtml = createLatestAdHtml(ad);
      if (!adHtml) {
        $adContainer.hide();
        return;
      }

      $adContainer.html(adHtml).show();
    });
  }

  // Latest posts: ad after first post (or random later if needed)
  insertStaticAd('.latest-news .block-content .row', 'latest', 'latestRandom');

  // Popular posts: ad at last position (fixed)
  insertStaticAd('.popular-widget .widget-content .row', 'popular', 'last');
});

// <><><><><><><> END JS FOR LATEST AND POPULAR POSTS ADS (STATIC) <><><><><><><>

// <><><><><><><> START JS FOR TOPIC POSTS ADS <><><><><><><>
$(document).ready(function () {
  function fetchAd(placementKey, callback) {
    $.ajax({
      url: `/ads/${placementKey}`,
      type: "GET",
      dataType: "json",
      success: (data) => callback(data),
      error: (xhr, status, error) => {
        // Silent fail - don't log errors for unavailable ads
        callback(null);
      },
    });
  }

  function createAdHtml(ad) {
    if (!ad || !ad.vertical_image || !ad.id) return "";

    return `
            <div class="col ad-card">
                <article class="post type-post panel vstack gap-2">
                    <div class="post-image panel overflow-hidden">
                        <figure class="featured-image m-0 ratio ratio-16x9 rounded overflow-hidden bg-gray-25 dark:bg-gray-800">
                            <a href="${ad.imageUrl || "#"}" target="_blank" class="position-cover" data-ad-id="${ad.id}">
                                <img class="media-cover image uc-transition-scale-up uc-transition-opaque"
                                     src="${ad.vertical_image}" 
                                     alt="${ad.image_alt || "Advertisement"}"
                                     data-uc-img="loading: lazy">
                            </a>
                        </figure>
                    </div>
                    <div class="post-header panel vstack gap-1">
                        <h3 class="post-title h6 sm:h5 xl:h4 m-0">
                            <a class="text-none hover:text-primary duration-150  text-truncate-2 m-0"
                               href="${ad.imageUrl || "#"}" data-ad-id="${ad.id}">${ad.title || "Sponsored Ad"}</a>
                        </h3>
                        <div class="post-meta panel text-gray-900 dark:text-white text-opacity-60">
                            <h6 class="badge bg-primary text-white">Sponsored</h6>
                        </div>
                    </div>
                </article>
            </div>
        `;
  }

  function insertInlineAd(containerId, placementKey) {
    var $container = $(`#${containerId}`);
    if (!$container.length) return;

    var posts = $container.children("div");
    if (posts.length === 0) return;

    // Pick a random post position
    var randomIndex = Math.floor(Math.random() * posts.length);
    var adContainer = $('<div class="ad-placeholder"></div>');
    $(posts[randomIndex]).after(adContainer);

    // Fetch and insert ad once
    fetchAd(placementKey, function (ad) {
      if (!ad) {
        adContainer.hide();
        return;
      }

      var adHtml = createAdHtml(ad);
      if (!adHtml) {
        adContainer.hide();
        return;
      }

      adContainer.html(adHtml).show();
    });
  }

  insertInlineAd("topic_post_ads", "topic_posts");
});

// <><><><><><><> END JS OF TOPIC POSTS ADS <><><><><><><>

// <><><><><><><> START JS FOR VIDEOS POSTS ADS <><><><><><><>
$(function () {
  function fetchAd(key, cb) {
    $.getJSON(`/ads/${key}`)
      .done(function (ad) {
        cb(ad);
      })
      .fail(function () {
        cb(null);
      });
  }

  function adCard(ad) {
    if (!ad || !ad.vertical_image || !ad.id) return '';

    return `
            <div>
                <article class="post type-post panel vstack gap-2 f-cat border p-2 dark:bg-gray-800 bg-white rounded">
                    <div class="post-image panel overflow-hidden">
                        <figure class="featured-image m-0 ratio ratio-16x9 rounded overflow-hidden bg-gray-25 dark:bg-gray-800">
                            <a href="${ad.imageUrl || '#'}" target="_blank" class="position-cover" data-ad-id="${ad.id}">
                                <img class="media-cover image" src="${ad.vertical_image}" alt="${ad.image_alt || 'Sponsored Ad'}">
                                <div class="post-category hstack gap-narrow justify-center align-items-center text-white">
                                    <span class="fs-6 fw-bold bg-primary px-2 py-1 rounded">Ad</span>
                                </div>
                            </a>
                        </figure>
                    </div>
                    <div class="post-header panel vstack gap-1 lg:gap-2 rounded dark:bg-gray-800 bg-white">
                        <h5 class="post-title h6 sm:h5 xl:h5 m-0 text-truncate-2">
                            <a href="${ad.imageUrl || '#'}" target="_blank" class="text-none hover:text-primary duration-150" data-ad-id="${ad.id}">
                                ${ad.title || 'Sponsored Ad'}
                            </a>
                        </h5>
                        <div class="post-meta panel fs-7 fw-medium text-gray-900 dark:text-white text-opacity-60">
                            <span class="badge bg-primary text-white">Sponsored</span>
                        </div>
                    </div>
                </article>
            </div>`;
  }

  function insertAdOnce(container, key) {
    let $container = $(container);
    if (!$container.length) return;

    let posts = $(`${container} > div`);
    let adHolder = $('<div class="ad-placeholder" style="display: none;"></div>');

    if (posts.length) {
      posts.eq(Math.floor(Math.random() * posts.length)).after(adHolder);
    } else {
      $container.prepend(adHolder);
    }

    // Load ad once
    fetchAd(key, ad => {
      const adHtml = adCard(ad);
      if (adHtml) {
        adHolder.html(adHtml).show();
      } else {
        adHolder.hide();
      }
    });
  }

  insertAdOnce("#videos-container", "videos");
});

// <><><><><><><> END JS OF VIDEOS POSTS ADS <><><><><><><>

// <><><><><><><> START JS FOR ALL POSTS ADS <><><><><><><>
$(function () {
  function fetchAd(key, cb) {
    $.getJSON(`/ads/${key}`)
      .done(function (ad) {
        cb(ad);
      })
      .fail(function () {
        cb(null);
      });
  }

  function adCard(ad) {
    if (!ad || !ad.vertical_image || !ad.id) return '';

    return `
            <div>
                <article class="post type-post panel vstack gap-2">
                    <div class="post-image panel overflow-hidden">
                        <figure class="featured-image m-0 ratio ratio-16x9 rounded uc-transition-toggle overflow-hidden">
                            <a href="${ad.imageUrl || '#'}" target="_blank" class="position-cover" data-ad-id="${ad.id}">
                                <img class="media-cover image uc-transition-scale-up uc-transition-opaque" src="${ad.vertical_image}" alt="${ad.image_alt || 'Sponsored Ad'}">
                                <div class="post-category hstack gap-narrow justify-center align-items-center text-white">
                                    <span class="fs-6 fw-bold bg-primary px-2 py-1 rounded">Ad</span>
                                </div>
                            </a>
                        </figure>
                    </div>
                    <div class="post-header panel vstack gap-1 lg:gap-2">
                        <h5 class="post-title h6 sm:h5 xl:h5 m-0 text-truncate-2">
                            <a href="${ad.imageUrl || '#'}" target="_blank" class="text-none hover:text-primary duration-150" data-ad-id="${ad.id}">
                                ${ad.title || 'Sponsored Ad'}
                            </a>
                        </h5>
                        <div class="post-meta panel fs-7 fw-medium text-gray-900 dark:text-white text-opacity-60">
                            <span class="badge bg-primary text-white">Sponsored Ad</span>
                        </div>
                    </div>
                </article>
            </div>`;
  }

  function insertAdOnce(container, key) {
    let $container = $(container);
    if (!$container.length) return;

    let posts = $(`${container} > div`);
    let adHolder = $('<div class="ad-placeholder" style="display: none;"></div>');

    if (posts.length) {
      posts.eq(Math.floor(Math.random() * posts.length)).after(adHolder);
    } else {
      $container.prepend(adHolder);
    }

    // Load ad once
    fetchAd(key, ad => {
      const adHtml = adCard(ad);
      if (adHtml) {
        adHolder.html(adHtml).show();
      } else {
        adHolder.hide();
      }
    });
  }

  insertAdOnce("#posts-ad-container", "posts");
});

// <><><><><><><> END JS OF ALL POSTS ADS <><><><><><><>

// <><><><><><><> START JS FOR FOOTER AND HEADER ADS <><><><><><><>
$(function () {
  function fetchAd(key, cb) {
    $.getJSON(`/ads/${key}`)
      .done(function (ad) {
        cb(ad);
      })
      .fail(function () {
        cb(null);
      });
  }

  function footerAdCard(ad) {
    if (!ad || !ad.horizontal_image || !ad.id) return "";

    return `
            <div class="footer-ad panel vstack gap-2 justify-center items-center">
                <a href="${ad.imageUrl || '#'}" 
                   data-ad-id="${ad.id}" 
                   target="_blank" 
                   class="ad-click-link d-inline-block">
                    <img src="${ad.horizontal_image}" 
                         alt="${ad.image_alt || 'Sponsored Ad'}" 
                         class="img-fluid rounded shadow-sm mx-auto rotatingAd ">
                </a>
            </div>`;
  }

  function rotateFooterAd(container, key, interval = 20000) {
    let holder = $(container);
    if (!holder.length) return;

    function loadAd() {
      fetchAd(key, ad => {
        const adHtml = footerAdCard(ad);
        if (adHtml) {
          holder.fadeOut(400, function () {
            holder.html(adHtml).fadeIn(400);
          });
        } else {
          holder.fadeOut(400).empty();
        }
      });
    }

    loadAd();
    setInterval(loadAd, interval);
  }

  rotateFooterAd("#footer-ad-container", "footer", 20000);
  rotateFooterAd("#header-ad-container", "header", 20000);
});
// <><><><><><><> END JS FOR FOOTER AND HEADER ADS <><><><><><><>

// <><><><><><><> START JS FOR SIDEBAR ADS <><><><><><><>
$(function () {
  function fetchAd(key, cb) {
    $.getJSON(`/ads/${key}`)
      .done(function (ad) {
        cb(ad);
      })
      .fail(function () {
        cb(null);
      });
  }

  function adCard(ad) {
    if (!ad || !ad.horizontal_image || !ad.id) return '';

    return `
            <a href="${ad.imageUrl || '#'}" target="_blank" data-ad-id="${ad.id}" class="ad-click-link">
                <img src="${ad.horizontal_image}" 
                     alt="${ad.image_alt || 'Sponsored Ad'}">
            </a>`;
  }

  function rotateSidebarAd(container, key, interval = 2000) {
    let holder = $(container);
    if (!holder.length) return;

    function loadAd() {
      fetchAd(key, ad => {
        const adHtml = adCard(ad);
        if (adHtml) {
          holder.html(adHtml);
        } else {
          holder.empty();
        }
      });
    }

    loadAd();
    setInterval(loadAd, interval);
  }

  rotateSidebarAd("#left-sidebar-ad", "left_sidebar", 2000);
  rotateSidebarAd("#right-sidebar-ad", "right_sidebar", 2000);
});
// <><><><><><><> END JS FOR SIDEBAR ADS <><><><><><><>

$(document).ready(function () {
  $('#web-subscriber-button').click(function (event) {
    event.preventDefault();

    let email = $('#subscriber_email').val().trim();
    let input = $('#subscriber_email');
    let errorDiv = $('#subscriber-error-top');
    let button = $(this);

    // Get validation messages from data attributes
    let msgRequired = input.data('email-required');
    let msgInvalid = input.data('email-invalid');
    let msgTaken = input.data('email-taken');
    let msgSubscribed = input.data('email-subscribed');

    // Hide previous error
    errorDiv.addClass('d-none').text('');

    // Basic client-side validation before AJAX
    if (email === '') {
      iziToast.error({
        title: msgRequired,
        position: 'topCenter',
      });
      return;
    }

    // Simple email format check
    let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
      iziToast.error({
        title: msgInvalid,
        position: 'topCenter',
      });
      return;
    }

    // Disable button to prevent multiple clicks
    button.prop('disabled', true);

    $.ajax({
      url: '/subscribe/store', // Laravel route
      method: 'POST',
      data: {
        email: email,
        _token: $('meta[name="csrf-token"]').attr('content')
      },
      success: function (response) {
        if (response.status == 1) {
          // Success toast
          iziToast.success({
            title: response.message,
            position: 'topCenter',
          });

          // Update button state with localized subscribed message
          button.removeClass('btn-primary').addClass('btn-success');
          button.html('<i class="bi bi-check-circle"></i> ' + msgSubscribed);
          $('#subscriber_email').val(''); // clear input
        } else {
          // Failure toast
          iziToast.error({
            title: response.message,
            position: 'topCenter',
          });
          button.prop('disabled', false);
        }
      },
      error: function (xhr) {
        if (xhr.status === 422) {
          let errors = xhr.responseJSON.errors;
          if (errors.email) {
            let errorMsg = errors.email[0];
            // Replace Laravel's default with localized message
            if (errorMsg.toLowerCase().includes('taken')) {
              errorMsg = msgTaken;
            }
            iziToast.error({
              title: errorMsg,
              position: 'topCenter',
            });
          }
        }
        button.prop('disabled', false);
      }
    });
  });
});

$(document).ready(function () {
  $('#index-subscriber-button').click(function (event) {
    event.preventDefault();

    let email = $('#index_subscriber_email').val().trim();
    let input = $('#index_subscriber_email');
    let errorDiv = $('#subscriber-error-top-index');
    let button = $(this);

    // Get validation messages from data attributes
    let msgRequired = input.data('email-required');
    let msgInvalid = input.data('email-invalid');
    let msgTaken = input.data('email-taken');
    let msgSubscribed = input.data('email-subscribed');

    // Hide previous error
    errorDiv.addClass('d-none').text('');

    // Basic client-side validation before AJAX
    if (email === '') {
      iziToast.error({
        title: msgRequired,
        position: 'topCenter',
      });
      return;
    }

    // Simple email format check
    let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
      iziToast.error({
        title: msgInvalid,
        position: 'topCenter',
      });
      return;
    }

    // Disable button to prevent multiple clicks
    button.prop('disabled', true);

    $.ajax({
      url: '/subscribe/store', // Laravel route
      method: 'POST',
      data: {
        email: email,
        _token: $('meta[name="csrf-token"]').attr('content')
      },
      success: function (response) {
        if (response.status == 1) {
          // Success toast
          iziToast.success({
            title: response.message,
            position: 'topCenter',
          });

          // Update button state with localized subscribed message
          button.removeClass('btn-primary').addClass('btn-success');
          button.html('<i class="bi bi-check-circle"></i> ' + msgSubscribed);
          $('#index_subscriber_email').val(''); // clear input
        } else {
          // Failure toast
          iziToast.error({
            title: response.message,
            position: 'topCenter',
          });
          button.prop('disabled', false);
        }
      },
      error: function (xhr) {
        if (xhr.status === 422) {
          let errors = xhr.responseJSON.errors;
          if (errors.email) {
            let errorMsg = errors.email[0];
            // If Laravel says "email has already been taken", show our localized message
            if (errorMsg.toLowerCase().includes('taken')) {
              errorMsg = msgTaken;
            }
            iziToast.error({
              title: errorMsg,
              position: 'topCenter',
            });
          }
        }
        button.prop('disabled', false);
      }
    });
  });
});

$(document).ready(function () {
  $('#model-subscriber-button').click(function (event) {
    event.preventDefault();

    let email = $('#model-subscriber_email').val().trim();
    let input = $('#model-subscriber_email');
    let errorDiv = $('#model-subscriber-error-top');
    let button = $(this);

    // Get validation messages from data attributes
    let msgRequired = input.data('email-required');
    let msgInvalid = input.data('email-invalid');
    let msgTaken = input.data('email-taken');
    let msgSubscribed = input.data('email-subscribed');

    // Hide previous error
    errorDiv.addClass('d-none').text('');

    // Basic client-side validation before AJAX
    if (email === '') {
      iziToast.error({
        title: msgRequired,
        position: 'topCenter',
      });
      return;
    }

    // Simple email format check
    let emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
    if (!emailRegex.test(email)) {
      iziToast.error({
        title: msgInvalid,
        position: 'topCenter',
      });
      return;
    }

    // Disable button to prevent multiple clicks
    button.prop('disabled', true);

    $.ajax({
      url: '/subscribe/store', // Laravel route
      method: 'POST',
      data: {
        email: email,
        _token: $('meta[name="csrf-token"]').attr('content')
      },
      success: function (response) {
        if (response.status == 1) {
          // Success toast
          iziToast.success({
            title: response.message,
            position: 'topCenter',
          });

          // Update button state with localized subscribed message
          button.removeClass('btn-primary').addClass('btn-success');
          button.html('<i class="bi bi-check-circle"></i> ' + msgSubscribed);
          $('#model-subscriber_email').val(''); // clear input
        } else {
          // Failure toast
          iziToast.error({
            title: response.message,
            position: 'topCenter',
          });
          button.prop('disabled', false);
        }
      },
      error: function (xhr) {
        if (xhr.status === 422) {
          let errors = xhr.responseJSON.errors;
          if (errors.email) {
            let errorMsg = errors.email[0];
            // Localize "email taken" message
            if (errorMsg.toLowerCase().includes('taken')) {
              errorMsg = msgTaken;
            }
            iziToast.error({
              title: errorMsg,
              position: 'topCenter',
            });
          }
        }
        button.prop('disabled', false);
      }
    });
  });
});


document.addEventListener("DOMContentLoaded", function () {
  document.querySelectorAll("[id^='timer-']").forEach(function (el) {
    let seconds = parseInt(el.getAttribute("data-seconds"), 10);
    let btnId = el.getAttribute("data-btn");
    let btn = document.getElementById(btnId);

    function updateTimer() {
      if (seconds <= 0) {
        el.innerText = "Expired";
        if (btn) {
          btn.disabled = true;
          btn.classList.add('btn-secondary');
          btn.classList.remove('btn-success');
        }
        return;
      }
      let h = Math.floor(seconds / 3600);
      let m = Math.floor((seconds % 3600) / 60);
      let s = seconds % 60;
      el.innerText = `${h}h ${m}m ${s}s`;
      seconds--;
      setTimeout(updateTimer, 1000);
    }

    if (!isNaN(seconds) && seconds > 0) {
      updateTimer();
    }
  });
});

document.addEventListener('DOMContentLoaded', function () {
  const waveformContainers = document.querySelectorAll('[id^="waveform-"]');

  waveformContainers.forEach(function (container) {
    const postId = container.id.replace('waveform-', '');
    const audioUrl = container.dataset.audioUrl;

    if (!audioUrl) return;

    const wavesurfer = WaveSurfer.create({
      container: container,
      waveColor: '#4F4A85',
      progressColor: '#eb4432',
      height: 60,
      responsive: true,
      normalize: true,
      backend: 'MediaElement',
      barWidth: 2,
      barGap: 1,
      barRadius: 3
    });

    wavesurfer.load(audioUrl);

    const playBtn = document.getElementById(`play-btn-${postId}`);
    const playIcon = document.getElementById(`play-icon-${postId}`);
    const pauseIcon = document.getElementById(`pause-icon-${postId}`);

    // Play button click - toggle play/pause
    if (playBtn) {
      playBtn.addEventListener('click', function () {
        wavesurfer.playPause();
      });
    }

    // Play/Pause on waveform click (optional)
    wavesurfer.on('interaction', function () {
      wavesurfer.playPause();
    });

    // Update icon on play
    wavesurfer.on('play', function () {
      playIcon.style.display = 'none';
      pauseIcon.style.display = 'inline-block';
    });

    // Update icon on pause
    wavesurfer.on('pause', function () {
      playIcon.style.display = 'inline-block';
      pauseIcon.style.display = 'none';
    });

    // Update icon when audio finishes
    wavesurfer.on('finish', function () {
      playIcon.style.display = 'inline-block';
      pauseIcon.style.display = 'none';
    });

    // Ready event
    wavesurfer.on('ready', function () {
      console.log(`Waveform ready for post ${postId}`);
    });

    // Store wavesurfer instance
    window.wavesurfers = window.wavesurfers || {};
    window.wavesurfers[postId] = wavesurfer;
  });
});



$(document).on('click', '.pin-post-btn', function () {
  let btn = $(this);
  let postId = btn.data('post-id');
  let url = btn.data('url');
  let csrf = btn.data('csrf');

  $.ajax({
    url: url,
    type: "POST",
    data: {
      post_id: postId,
      _token: csrf
    },
    success: function (response) {
      if (response.success) {
        // Toggle icon visually
        if (response.is_pinned) {
          btn.html('<i class="bi bi-pin-angle-fill text-primary fs-4"></i>');
          btn.attr('title', 'Unpin Post');
        } else {
          btn.html('<i class="bi bi-pin-angle fs-4"></i>');
          btn.attr('title', 'Pin Post');
        }
        // Success toast with iziToast
        iziToast.success({
          title: response.message,
          position: 'topCenter',
        });
      } else {
        iziToast.error({
          title: response.message,
          position: 'topCenter',
        });
      }
    },
    error: function () {
      iziToast.error({
        title: "Something went wrong.",
        position: 'topCenter',
      });
    }
  });
});

document.addEventListener('DOMContentLoaded', function () {
  function updateTime() {
    const date = new Date();
    const options = { weekday: 'long', year: 'numeric', month: 'long', day: 'numeric' };
    const time = date.toLocaleTimeString();
    const day = date.toLocaleDateString(undefined, options);
    document.getElementById('time').innerHTML =
      `${day}`;
  }

  setInterval(updateTime, 1000);
  updateTime();
});
